/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm, describe, it, expect, beforeEach, spyOn */

//'use strict';
define([ 'Portal', 'backbone', 'marionette',
//	'applets/wound-care-applet/util',
	'applets/wound-care-applet/Controller'

],
	function (Portal, Backbone, Marionette, WoundCareAppletController) {

		return Portal.module('WoundCareApplet',
			function (WoundCareApplet, Portal, Backbone, Marionette, $, _, User) {
				WoundCareApplet.Router = Marionette.AppRouter.extend({
					appRoutes: {
						'wound-care': 'main',
						'braden-scale': 'braden',
						'braden-review/:sum': 'bradenReview',
						'prev-inspections': 'prevInspections',
						'prev-inspection/:id': 'prevInspection',
						'new-inspection': 'newSkinInspection',
						'risk-factors': 'riskFactors',
						'risk-factors/:past': 'riskFactors',
						'education' : 'education',
						'listgen' : 'listgen',
						'landing-page' : 'landingPage'
					}
				});
				var woundCareMainController;

				WoundCareApplet.addInitializer(function () {
					woundCareMainController = new WoundCareAppletController({portal:Portal,woundCareApplet:WoundCareApplet});
					//wcc is just for debugging
					window.wcc = woundCareMainController;
					WoundCareApplet.router = new WoundCareApplet.Router({
						controller: woundCareMainController
					});
				});


			});
	});
